#include <stdio.h>
#include <stdbool.h>
//BEGIN CUT
#include <string.h>
//END CUT

// TP 1 de IN330 -- exercices préparatoires
// LG et SM pour IN330, 2024
// BEGIN CUT
// 4. Dans chaque ligne on a isolé le "premier mot", i.e. le mnémonique de
//    l'instruction, qui est copié dans ins. La valeur de retour de sscanf()
//    est 1 s'il y a au moins un mot dans la chaîne et EOF (-1) sinon.
// 5. Cette fois on isole le mnémonique, et le premier argument s'il existe.
// 6. On continue de les compiler: "%s%s%s%s" (sscanf() consomme les espaces
//    avant chaque %s automatiquement)
// END CUT

void simplify_punct(char *str) {
  // TODO : Écrire la fonction.
  //BEGIN CUT
  for (size_t i = 0; i < strlen(str); i++) {
    if (str[i] == '(' || str[i] == ')' || str[i] == ',')
      str[i] = ' ';
  }
  //END CUT
}

bool is_comment(const char *str) {
  // TODO : Remplacer le code fourni.
  //BEGIN CUT
  return (str[0]=='#');
  //END CUT
  
  //UNCOMMENT return false;
}

bool split_line(const char *str, char *ins, char *arg1, char *arg2, char *arg3) {
  // TODO : Initialiser ins, arg1, arg2, arg3 avec strcpy()
  // TODO : Tester si la ligne est utile
  // TODO : Utiliser sscanf()
  //BEGIN CUT
  // WARNING PROF : il faut simplifier avant de découper
  strcpy(ins, "");
  strcpy(arg1, "");
  strcpy(arg2, "");
  strcpy(arg3, "");

  if (is_comment(str) || strlen(str)==0) return false;
  int ret = sscanf(str, "%s%s%s%s", ins, arg1, arg2, arg3);
  return (ret > 0);
  //END CUT
  
  //UNCOMMENT return false;
}

int main(void)
{
  // Note: pas de \n parce qu'on les a enlevés dans l'exo 1.
  char examples[6][32] = {
    "addi x1,  x0, 8",   // instruction addi classique
    "   li   a0,5",      // deux arguments seulement
    " ",                 // ligne vide
    "nop  ",             // aucun argument
    "lw  ra,8(a4 )  ",   // load word avec parenthèses
    "#   commentaire",   // ligne de commentaire
  };

  // TODO : Simplifier la ponctuation de toutes les chaînes
  // TODO : Pour chaque chaîne d'exemple... essayer "%s", "%s%s", split_line
  //BEGIN CUT
  for (int i = 0; i < 6; i++)
    simplify_punct(examples[i]);

  char ins[16] = "";
  char arg1[16] = "";
  char arg2[16] = "";
  char arg3[16] = "";
  int valret;

  for (int i = 0; i < 6; i++) {
    printf("Analysis of: \"%s\"\n", examples[i]);

    valret = sscanf(examples[i], "%s", ins);
    printf("%%s    -> %d, ins=\"%s\"\n", valret, ins);
    // On a isolé le premier mot.
    // la valeur de retour est 1 sauf dans le cas ligne vide (-1).

    valret = sscanf(examples[i], "%s%s", ins, arg1);
    printf("%%s%%s  -> %d, ins=\"%s\", arg1=\"%s\"\n", valret, ins, arg1);
    // On a isolé les deux premiers mots: instruction et, s'il existe, premier
    // argument.

    bool useful = split_line(examples[i], ins, arg1, arg2, arg3);
    if(useful)
      printf("split -> ins=\"%s\", arg1=\"%s\", arg2=\"%s\", arg3=\"%s\"\n\n",
          ins, arg1, arg2, arg3);
    else
      printf("split -> Line is useless\n\n");
  }
  //END CUT

  return 0;
}
