import re

print("Reading from logo.html\n")

with open("logo.html", "r") as fp:
	text = fp.read()

text = text.replace("&nbsp;", " ")
text = text.replace("&amp;", "&")
text = text.replace("<br>", "\n")

RE_SPAN = re.compile(r'<span style="color:#([0-9a-fA-F]{6})">')
RE_SPAN_END = re.compile(r'</span>')

chars = []
current_color = (0, 0, 0)

while text:
	if (m := RE_SPAN.match(text)) is not None:
		r = int(m[1][0:2], 16)
		g = int(m[1][2:4], 16)
		b = int(m[1][4:6], 16)
		current_color = (r, g, b)
		text = text[len(m[0]):]
	elif (m := RE_SPAN_END.match(text)) is not None:
		text = text[len(m[0]):]
	else:
		chars.append((text[0], current_color))
		text = text[1:]

for c, (r, g, b) in chars:
	print("\x1b[38;2;{};{};{}m".format(r, g, b), end="")
	print(c, end="")
print("\x1b[0m")

with open("logo.s", "w") as fp:
	for c, (r, g, b) in chars:
		fp.write(".long 0x{:02x}{:02x}{:02x}{:02x}\n".format(r, g, b, ord(c)))
print("Written asm encoding in logo.s")
